<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('withdrawals', function (Blueprint $table) {
            $table->bigIncrements('id')->startingValue(1000);
            $table->bigInteger('author_id')->unsigned();
            $table->double('amount', 18, 2);
            $table->string('method');
            $table->text('account');
            $table->tinyInteger('status')->default(1)->comment('1:Pending 2:Returned 3:Approved 4:Completed 5:Cancelled	');
            $table->foreign("author_id")->references("id")->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('withdrawals');
    }
};