<?php

namespace Database\Seeders;

use App\Models\HelpArticle;
use Faker\Factory as Faker;
use Illuminate\Database\Seeder;
use Str;

class ArticleSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        $usedTitles = [];

        foreach (range(1, 10) as $index) {

            $titlePatterns = [
                'The :adjective Guide to :topic',
                'Mastering :topic :adjective :noun',
                ':adjective :noun for :task',
                'Exploring :noun :adjective :noun',
                ':noun :adjective Tips and Tricks',
                'How to :verb :topic with :tool',
                'Step-by-Step Guide to :task',
            ];

            $adjectives = [
                'Ultimate', 'Complete', 'Advanced', 'Efficient', 'Practical', 'Comprehensive', 'Dynamic', 'Innovative', 'Proven',
                'Effective', 'Cutting-Edge', 'Scalable', 'Robust', 'Flexible', 'Streamlined', 'Powerful', 'High-Performance',
                'Strategic', 'Proficient', 'Time-Saving', 'Reliable', 'Versatile', 'Modular', 'Scalable', 'Interactive',
                'Responsive', 'Seamless', 'Optimized', 'Revolutionary', 'Secure', 'Agile', 'Effortless', 'Modern',
                'Professional', 'Simple', 'Efficient', 'Refined', 'Minimalistic', 'Elegant', 'Structured', 'Consistent',
            ];

            $nouns = [
                'Techniques', 'Solutions', 'Frameworks', 'Libraries', 'API', 'Components', 'Design', 'Processes', 'Principles',
                'Structures', 'Methodologies', 'Technologies', 'Systems', 'Architecture', 'Algorithms', 'Patterns',
                'Strategies', 'Configurations', 'Elements', 'Tools', 'Insights', 'Mechanisms', 'Modules', 'Plugins',
                'Extensions', 'Resources', 'Utilities', 'Workflows', 'Protocols', 'Schematics', 'Templates', 'Workarounds',
            ];

            $topics = [
                'PHP', 'Laravel', 'HTML', 'CSS', 'Web Development', 'Responsive Design', 'UI/UX', 'JavaScript', 'React',
                'Vue.js', 'Angular', 'Node.js', 'Tailwind CSS', 'Bootstrap', 'SASS', 'Front-End Development', 'Back-End Development',
                'APIs', 'RESTful APIs', 'GraphQL', 'Microservices', 'Cloud Computing', 'DevOps', 'Mobile Development',
                'Serverless Architectures', 'Database Management', 'Security Best Practices', 'SEO Optimization',
                'Performance Tuning', 'Cross-Browser Compatibility', 'E-Commerce Solutions', 'Custom Widgets', 'Interactive UI',
            ];

            $tasks = [
                'Optimizing Code', 'Building Applications', 'Designing Websites', 'Integrating APIs', 'Front-End Development',
                'Back-End Development', 'Automating Workflows', 'Creating Dynamic Websites', 'Enhancing User Experience',
                'Deploying Applications', 'Managing Databases', 'Improving Performance', 'Developing Custom Plugins',
                'Crafting Responsive Layouts', 'Creating Modular Designs', 'Streamlining Code', 'Scaling Applications',
                'Creating Reusable Components', 'Version Control', 'Troubleshooting Issues', 'Setting Up CI/CD Pipelines',
                'Automating Deployments', 'Securing Applications', 'Monitoring and Logging', 'Debugging Code', 'Caching Data',
            ];

            $verbs = [
                'Build', 'Optimize', 'Create', 'Develop', 'Design', 'Deploy', 'Enhance', 'Automate', 'Implement', 'Scale',
                'Integrate', 'Customize', 'Refactor', 'Debug', 'Test', 'Streamline', 'Improve', 'Upgrade', 'Secure',
                'Collaborate', 'Maintain', 'Configure', 'Monitor', 'Simplify', 'Manage', 'Innovate', 'Deploy', 'Extend',
            ];

            $tools = [
                'PHP', 'Laravel', 'Bootstrap', 'Tailwind', 'Vue.js', 'React', 'Angular', 'Sass', 'Gulp', 'Grunt',
                'Webpack', 'Node.js', 'Docker', 'Kubernetes', 'AWS', 'Firebase', 'Git', 'MySQL', 'PostgreSQL', 'MongoDB',
                'Redis', 'Elasticsearch', 'Vite', 'Jest', 'GraphQL', 'REST API', 'Tailwind UI', 'React Native',
                'Flutter', 'WordPress', 'WooCommerce', 'Nginx', 'Apache', 'Cloudflare',
            ];

            do {
                $pattern = $faker->randomElement($titlePatterns);

                $title = str_replace(
                    [':adjective', ':noun', ':topic', ':task', ':verb', ':tool'],
                    [
                        $faker->randomElement($adjectives),
                        $faker->randomElement($nouns),
                        $faker->randomElement($topics),
                        $faker->randomElement($tasks),
                        $faker->randomElement($verbs),
                        $faker->randomElement($tools),
                    ],
                    $pattern
                );
            } while (in_array($title, $usedTitles));

            $usedTitles[] = $title;

            $des = '<p><strong>What is Lorem Ipsum?</strong></p><p><strong>Lorem Ipsum</strong>&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industries standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p><figure class="image"><img style="aspect-ratio:1920/1080;" src="https://i.imgur.com/rIXWhIG.jpeg" width="1920" height="1080"></figure><p><strong>Where does it come from?</strong></p><p>Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of de Finibus Bonorum et Malorum (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, Lorem ipsum dolor sit amet.., comes from a line in section 1.10.32.</p><p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from de Finibus Bonorum et Malorum by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p><p><strong>Why do we use it?</strong></p><p>It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using "Content here, content here", making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for "lorem ipsum" will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).</p><figure class="image"><img style="aspect-ratio:1920/1080;" src="https://i.imgur.com/Uco0BTd.jpeg" width="1920" height="1080"></figure><p><strong>Where can I get some?</strong></p><p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which do not look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there is not anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.</p>';

            $article = HelpArticle::create([
                'title' => $title,
                'slug' => Str::slug($title),
                'body' => $des,
                'short_description' => Str::limit($faker->paragraphs(1, true), 150),
                'views' => $faker->numberBetween(0, 1000),
                'likes' => $faker->numberBetween(0, 500),
                'dislikes' => $faker->numberBetween(0, 200),
                'help_category_id' => 6,
            ]);
        }
    }
}
