<?php $__env->startSection('header_title', translate('Premium')); ?>
<?php $__env->startSection('title', translate('Premium')); ?>
<?php $__env->startSection('breadcrumbs', Breadcrumbs::render('premium')); ?>
<?php $__env->startSection('breadcrumbs_schema', Breadcrumbs::view('breadcrumbs::json-ld', 'premium')); ?>
<?php $__env->startSection('header_v3', true); ?>
<?php $__env->startSection('content'); ?>
    <div class="premium my-4">
        <?php if($countPlans > 0): ?>
            <?php
                $plans = [
                    [
                        'count' => $weeklyPlans->count(),
                        'id' => 'week-tab',
                        'target' => '#pills-week',
                        'label' => 'Weekly',
                    ],
                    [
                        'count' => $monthlyPlans->count(),
                        'id' => 'month-tab',
                        'target' => '#pills-month',
                        'label' => 'Monthly',
                    ],
                    [
                        'count' => $yearlyPlans->count(),
                        'id' => 'year-tab',
                        'target' => '#pills-year',
                        'label' => 'Yearly',
                    ],
                    [
                        'count' => $lifetimePlans->count(),
                        'id' => 'lifetime-tab',
                        'target' => '#pills-lifetime',
                        'label' => 'Lifetime',
                    ],
                ];

                $availablePlans = array_filter($plans, function ($plan) {
                    return $plan['count'] > 0;
                });

                $activePlan = $availablePlans ? reset($availablePlans) : null;
                $showSwitcher = count($availablePlans) > 1;
            ?>
            <?php if($showSwitcher): ?>
                <div class="d-flex justify-content-center mb-5" id="pills-tab" role="tablist">
                    <div class="plan-switcher">
                        <div class="plan-switcher-inner">
                            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($plan['count'] > 0): ?>
                                    <button
                                        class="plan-switcher-item <?php echo e($activePlan && $activePlan['id'] === $plan['id'] ? 'active' : ''); ?>"
                                        id="<?php echo e($plan['id']); ?>" data-bs-toggle="pill" data-bs-target="<?php echo e($plan['target']); ?>">
                                        <?php echo e(translate($plan['label'])); ?>

                                    </button>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php
                $firstAvailableTab = null;
                if ($weeklyPlans->count() > 0) {
                    $firstAvailableTab = 'pills-week';
                } elseif ($monthlyPlans->count() > 0) {
                    $firstAvailableTab = 'pills-month';
                } elseif ($yearlyPlans->count() > 0) {
                    $firstAvailableTab = 'pills-year';
                } elseif ($lifetimePlans->count() > 0) {
                    $firstAvailableTab = 'pills-lifetime';
                }
            ?>
            <div class="tab-content plans" id="pills-tabContent">
                <?php if($weeklyPlans->count() > 0): ?>
                    <div class="tab-pane fade <?php echo e($firstAvailableTab === 'pills-week' ? 'show active' : ''); ?>"
                        id="pills-week" role="tabpanel" tabindex="0">
                        <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-3 justify-content-center g-3">
                            <?php $__currentLoopData = $weeklyPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col">
                                    <?php echo $__env->make('themes.basic.partials.plan', ['plan' => $plan], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if($monthlyPlans->count() > 0): ?>
                    <div class="tab-pane fade <?php echo e($firstAvailableTab === 'pills-month' ? 'show active' : ''); ?>"
                        id="pills-month" role="tabpanel" tabindex="0">
                        <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-3 justify-content-center g-3">
                            <?php $__currentLoopData = $monthlyPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col">
                                    <?php echo $__env->make('themes.basic.partials.plan', ['plan' => $plan], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if($yearlyPlans->count() > 0): ?>
                    <div class="tab-pane fade <?php echo e($firstAvailableTab === 'pills-year' ? 'show active' : ''); ?>"
                        id="pills-year" role="tabpanel" tabindex="0">
                        <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-3 justify-content-center g-3">
                            <?php $__currentLoopData = $yearlyPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col">
                                    <?php echo $__env->make('themes.basic.partials.plan', ['plan' => $plan], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if($lifetimePlans->count() > 0): ?>
                    <div class="tab-pane fade <?php echo e($firstAvailableTab === 'pills-lifetime' ? 'show active' : ''); ?>"
                        id="pills-lifetime" role="tabpanel" tabindex="0">
                        <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-3 justify-content-center g-3">
                            <?php $__currentLoopData = $lifetimePlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col">
                                    <?php echo $__env->make('themes.basic.partials.plan', ['plan' => $plan], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div class="card-v border p-5 text-center">
                <span class="text-muted"><?php echo e(translate('No premium plans available')); ?></span>
            </div>
        <?php endif; ?>
        <div class="mt-5 text-center">
            <a href="<?php echo e(route('items.index', ['premium' => 'true'])); ?>" class="btn btn-outline-primary btn-lg px-5">
                <i class="fa-solid fa-crown me-1"></i>
                <?php echo e(translate('Browse premium items')); ?>

            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('themes.basic.layouts.single', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/vironeer/Desktop/Workspace/market/resources/views/themes/basic/premium.blade.php ENDPATH**/ ?>