<?php $__env->startSection('section', translate('System')); ?>
<?php $__env->startSection('title', translate('Cron Job')); ?>
<?php $__env->startSection('container', 'container-max-lg'); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <span><?php echo e(translate('Command')); ?></span>
        </div>
        <div class="card-body p-4">
            <div class="mb-3">
                <?php if(@$settings->cronjob->last_execution): ?>
                    <div class="mb-2">
                        <i class="fw-light">
                            <?php echo e(str('Last Execution: {datetime}')->replace('{datetime}', dateFormat(@$settings->cronjob->last_execution))); ?>

                        </i>
                    </div>
                <?php endif; ?>
                <div class="input-group">
                    <input id="cronInput" type="text" class="form-control form-control-md"
                        value="wget -q -O /dev/null <?php echo e(@$settings->cronjob->key ? route('cronjob', ['key' => @$settings->cronjob->key]) : route('cronjob')); ?>"
                        readonly>
                    <button class="btn btn-primary btn-copy" type="button" data-clipboard-target="#cronInput"><i
                            class="far fa-clone"></i></button>
                </div>
                <div class="input-text mt-2">
                    <?php echo e(translate('The cron job command must be set to run every minute')); ?> ( <code>* * * * *</code> ).
                </div>
            </div>
            <div class="row align-items-center g-3">
                <div class="col-12 col-lg-auto">
                    <form action="<?php echo e(route('admin.system.cronjob.key-generate')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button class="btn btn-outline-primary btn-md w-100 action-confirm">
                            <i class="fa-solid fa-rotate me-2"></i>
                            <?php echo e(translate('Generate Key')); ?></button>
                    </form>
                </div>
                <div class="col-12 col-lg-auto">
                    <form action="<?php echo e(route('admin.system.cronjob.key-remove')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button class="btn btn-danger btn-md w-100 action-confirm" <?php if(!$settings->cronjob->key): echo 'disabled'; endif; ?>>
                            <i class="fa-regular fa-trash-can me-2"></i>
                            <?php echo e(translate('Remove Key')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->startPush('scripts_libs'); ?>
        <script src="<?php echo e(asset('vendor/libs/clipboard/clipboard.min.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.grid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/vironeer/Desktop/Workspace/market/resources/views/admin/system/cronjob.blade.php ENDPATH**/ ?>