<footer class="footer mt-auto">
    <div class="footer-upper">
        <div class="container container-custom">
            <?php if(isAddonActive('newsletter')): ?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('newsletter.footer', [])->html();
} elseif ($_instance->childHasBeenRendered('AUvFan5')) {
    $componentId = $_instance->getRenderedChildComponentId('AUvFan5');
    $componentTag = $_instance->getRenderedChildComponentTagName('AUvFan5');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('AUvFan5');
} else {
    $response = \Livewire\Livewire::mount('newsletter.footer', []);
    $html = $response->html();
    $_instance->logRenderedChild('AUvFan5', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php endif; ?>
            <?php if($themeSettings->footer->footer_about || $footerLinks->count() > 0): ?>
                <div class="row g-5">
                    <?php if($themeSettings->footer->footer_about): ?>
                        <div class="col-12 col-lg-5">
                            <a href="<?php echo e(route('home')); ?>" class="logo h3 mb-4 fw-700">
                                <img src="<?php echo e(asset($themeSettings->footer->footer_logo)); ?>"
                                    alt="<?php echo e(@$settings->general->site_name); ?>" />
                            </a>
                            <p class="footer-text fw-500"><?php echo e($themeSettings->footer->footer_about_content); ?></p>
                            <?php
                                $socialLinksSettings = @$settings->social_links;
                                $hasSocialLinks =
                                    $socialLinksSettings->facebook ||
                                    $socialLinksSettings->x ||
                                    $socialLinksSettings->linkedin ||
                                    $socialLinksSettings->youtube ||
                                    $socialLinksSettings->instagram ||
                                    $socialLinksSettings->pinterest;
                            ?>
                            <?php if($hasSocialLinks): ?>
                                <div class="socials socials-footer mt-4">
                                    <?php if($socialLinksSettings->facebook): ?>
                                        <a href="https://facebook.com/<?php echo e($socialLinksSettings->facebook); ?>"
                                            target="_blank" class="social-btn social-facebook">
                                            <i class="fab fa-facebook-f"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if($socialLinksSettings->x): ?>
                                        <a href="https://x.com/<?php echo e($socialLinksSettings->x); ?>" target="_blank"
                                            class="social-btn social-x">
                                            <i class="fab fa-x-twitter"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if($socialLinksSettings->linkedin): ?>
                                        <a href="https://linkedin.com/in/<?php echo e($socialLinksSettings->linkedin); ?>"
                                            target="_blank" class="social-btn social-linkedin">
                                            <i class="fab fa-linkedin"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if($socialLinksSettings->youtube): ?>
                                        <a href="https://youtube.com/<?php echo e('@' . $socialLinksSettings->youtube); ?>"
                                            target="_blank" class="social-btn social-youtube">
                                            <i class="fab fa-youtube"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if($socialLinksSettings->instagram): ?>
                                        <a href="https://instagram.com/<?php echo e($socialLinksSettings->instagram); ?>"
                                            target="_blank" class="social-btn social-instagram">
                                            <i class="fab fa-instagram"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if($socialLinksSettings->pinterest): ?>
                                        <a href="https://pinterest.com/<?php echo e($socialLinksSettings->pinterest); ?>"
                                            target="_blank" class="social-btn social-pinterest">
                                            <i class="fab fa-pinterest"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            <div class="mt-4">
                                <div class="row row-cols-auto align-items-center g-4">
                                    <div class="col">
                                        <div class="footer-counter">
                                            <p class="footer-counter-text">
                                                <?php echo e(number_format($themeSettings->footer->footer_items_sold)); ?></p>
                                            <h6 class="footer-counter-title">
                                                <?php echo e(translate('Items Sold')); ?>

                                            </h6>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="footer-counter">
                                            <p class="footer-counter-text">
                                                <?php echo e(getAmount($themeSettings->footer->footer_authors_earnings, 0, '.', ',')); ?>

                                            </p>
                                            <h6 class="footer-counter-title">
                                                <?php echo e(translate('Authors Earnings')); ?>

                                            </h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="col-12  <?php echo e($themeSettings->footer->footer_about ? 'col-lg-7' : ''); ?>">
                        <div class="row row-cols-2 row-cols-sm-3 g-5">
                            <?php $__currentLoopData = $footerLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $footerLink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($footerLink->children->count() > 0): ?>
                                    <div class="col">
                                        <div class="footer-title">
                                            <span class="h5"> <?php echo e($footerLink->name); ?></span>
                                            <div class="footer-title-divider"></div>
                                        </div>
                                        <ul class="footer-links list-unstyled mb-0">
                                            <?php $__currentLoopData = $footerLink->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="footer-link">
                                                    <a href="<?php echo e($child->link); ?>"
                                                        <?php echo e($child->isExternal() ? 'target=_blank' : ''); ?>

                                                        class="footer-text"><?php echo e($child->name); ?></a>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                <?php else: ?>
                                    <div class="col">
                                        <a href="<?php echo e($footerLink->link); ?>"
                                            <?php echo e($footerLink->isExternal() ? 'target=_blank' : ''); ?>

                                            class="footer-link"><?php echo e($footerLink->name); ?></a>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="footer-lower">
        <div class="container container-custom">
            <div class="row row-cols-1 row-cols-sm-auto align-items-center justify-content-between g-3">
                <div class="col">
                    <p class="footer-copyright text-center small mb-0">
                        &copy; <span data-year></span>
                        <?php echo e(@$settings->general->site_name); ?> - <?php echo e(translate('All rights reserved')); ?>.
                    </p>
                </div>
                <?php if($themeSettings->footer->footer_payment_methods): ?>
                    <div class="col d-flex justify-content-center">
                        <div class="footer-payment">
                            <img src="<?php echo e(asset($themeSettings->footer->footer_payment_methods_logo)); ?>"
                                alt="<?php echo e(@$settings->general->site_name); ?>" />
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</footer>
<?php /**PATH /Users/vironeer/Desktop/Workspace/market/resources/views/themes/basic/includes/footer.blade.php ENDPATH**/ ?>