<?php $__env->startSection('section', translate('System')); ?>
<?php $__env->startSection('title', translate('Addons')); ?>
<?php $__env->startSection('upload_modal', translate('Upload')); ?>
<?php $__env->startSection('container', 'container-max-lg'); ?>
<?php $__env->startSection('content'); ?>
    <?php if($addons->count() > 0): ?>
        <div class="card">
            <ol class="list-group list-group-flush">
                <?php $__currentLoopData = $addons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="list-group-item px-4 py-4">
                        <div class="row g-3 align-items-center">
                            <div class="col-auto">
                                <?php if($addon->action): ?>
                                    <a href="<?php echo e(adminUrl($addon->action)); ?>">
                                        <img src="<?php echo e(asset($addon->thumbnail)); ?>" alt="<?php echo e($addon->name); ?>" width="70px"
                                            height="70px">
                                    </a>
                                <?php else: ?>
                                    <img src="<?php echo e(asset($addon->thumbnail)); ?>" alt="<?php echo e($addon->name); ?>" width="70px"
                                        height="70px">
                                <?php endif; ?>
                            </div>
                            <div class="col">
                                <div class="row g-3 align-items-center">
                                    <div class="col-xl-10">
                                        <?php if($addon->action): ?>
                                            <a href="<?php echo e(adminUrl($addon->action)); ?>">
                                                <h5 class="text-dark"><?php echo e($addon->name); ?></h5>
                                            </a>
                                        <?php else: ?>
                                            <h5 class="text-dark"><?php echo e($addon->name); ?></h5>
                                        <?php endif; ?>
                                        <span
                                            class="text-muted"><?php echo e(translate('Version: :version', ['version' => $addon->version])); ?></span>
                                    </div>
                                    <div class="col">
                                        <div class="row g-3">
                                            <?php if(!$addon->hasNoStatus()): ?>
                                                <div class="col-12 col-lg-6 col-xl-12">
                                                    <input class="addon-status" type="checkbox" name="status"
                                                        data-toggle="toggle"
                                                        data-update-link="<?php echo e(route('admin.system.addons.update', $addon->id)); ?>"
                                                        <?php echo e($addon->isActive() ? 'checked' : ''); ?>>
                                                </div>
                                            <?php endif; ?>
                                            <?php if($addon->action): ?>
                                                <div class="col-12 col-lg-6 col-xl-12">
                                                    <a href="<?php echo e(adminUrl($addon->action)); ?>"
                                                        class="btn btn-secondary w-100"><i
                                                            class="fa fa-cog me-2"></i><?php echo e(translate('Settings')); ?></a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ol>
        </div>
    <?php else: ?>
        <div class="card">
            <div class="card-body">
                <?php echo $__env->make('admin.partials.empty', ['empty_classes' => 'empty-lg'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    <?php endif; ?>
    <div class="modal fade" id="uploadModal" tabindex="-1" aria-labelledby="uploadModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <h5 class="modal-header bg-primary text-white mb-0"><?php echo e(translate('Upload an addon')); ?></h5>
                <div class="modal-body p-4">
                    <div class="note note-warning">
                        <h5 class="mb-2"><strong><?php echo e(translate('Important!')); ?></strong></h5>
                        <ul class="mb-0">
                            <li class="mb-1">
                                <?php echo e(translate('Make sure you are uploading the correct files.')); ?>

                            </li>
                            <li class="mb-0">
                                <?php echo e(translate('Before uploading a new addon make sure to take a backup of your website files and database.')); ?>

                            </li>
                        </ul>
                    </div>
                    <form action="<?php echo e(route('admin.system.addons.upload')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(translate('Addon Purchase Code')); ?> </label>
                            <input type="text" name="purchase_code" class="form-control form-control-lg"
                                placeholder="<?php echo e(translate('Purchase code')); ?>" value="<?php echo e(old('purchase_code')); ?>"
                                required>
                        </div>
                        <div class="mb-4">
                            <label class="form-label"><?php echo e(translate('Addon Files (Zip)')); ?> </label>
                            <input type="file" name="addon_files" class="form-control form-control-lg" accept=".zip"
                                required>
                        </div>
                        <div class="row justify-content-center g-3">
                            <div class="col-12 col-lg">
                                <button type="button" class="btn btn-secondary btn-lg w-100" data-bs-dismiss="modal"
                                    aria-label="Close"><?php echo e(translate('Close')); ?></button>
                            </div>
                            <div class="col-12 col-lg">
                                <button class="btn btn-primary btn-lg w-100"><?php echo e(translate('Upload')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.grid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/vironeer/Desktop/Workspace/market/resources/views/admin/system/addons.blade.php ENDPATH**/ ?>