<?php $__env->startSection('section', translate('System')); ?>
<?php $__env->startSection('title', translate('Editor Images')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header p-3 border-bottom-small">
            <form action="<?php echo e(url()->current()); ?>" method="GET">
                <div class="row g-3">
                    <div class="col-12 col-lg-10">
                        <input type="text" name="search" class="form-control" placeholder="<?php echo e(translate('Search...')); ?>"
                            value="<?php echo e(request('search') ?? ''); ?>">
                    </div>
                    <div class="col">
                        <button class="btn btn-primary w-100"><i class="fa fa-search"></i></button>
                    </div>
                    <div class="col">
                        <a href="<?php echo e(url()->current()); ?>" class="btn btn-secondary w-100"><?php echo e(translate('Reset')); ?></a>
                    </div>
                </div>
            </form>
        </div>
        <div>
            <?php if($editorImages->count() > 0): ?>
                <div class="overflow-hidden">
                    <div class="table-custom-container">
                        <table class="table-custom table">
                            <thead>
                                <tr class="bg-light">
                                    <th><?php echo e(translate('ID')); ?></th>
                                    <th><?php echo e(translate('Details')); ?></th>
                                    <th class="text-center"><?php echo e(translate('Uploaded Date')); ?></th>
                                    <th class="text-end"><?php echo e(translate('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $editorImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $editorImage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($editorImage->id); ?></td>
                                        <td>
                                            <div class="vironeer-content-box">
                                                <span class="vironeer-content-image">
                                                    <img src="<?php echo e($editorImage->getLink()); ?>">
                                                </span>
                                                <div>
                                                    <span
                                                        class="text-reset"><?php echo e(shorterText($editorImage->name, 40)); ?></span>
                                                    <p class="text-muted small mb-0">
                                                        <?php echo e($editorImage->getLink()); ?>

                                                    </p>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center"><?php echo e(dateFormat($editorImage->created_at)); ?></td>
                                        <td class="text-end">
                                            <form
                                                action="<?php echo e(route('admin.system.editor-images.destroy', $editorImage->id)); ?>"
                                                method="POST">
                                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                <button class="action-confirm btn btn-danger"><i
                                                        class="far fa-trash-alt"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php else: ?>
                <?php echo $__env->make('admin.partials.empty', ['empty_classes' => 'empty-lg'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        </div>
    </div>
    <?php echo e($editorImages->links()); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.grid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/vironeer/Desktop/Workspace/market/resources/views/admin/system/editor-images.blade.php ENDPATH**/ ?>