<!DOCTYPE html>
<html lang="<?php echo e(getLocale()); ?>" dir="<?php echo e(getDirection()); ?>">

<head>
    <?php echo $__env->make('admin.includes.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.includes.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body>
    <?php echo $__env->make('admin.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="vironeer-page-content">
        <?php echo $__env->make('admin.includes.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="container <?php echo $__env->yieldContent('container'); ?>">
            <div class="vironeer-page-body">
                <div class="py-4 g-3">
                    <div class="row g-3 align-items-center">
                        <div class="col">
                            <?php echo $__env->make('admin.partials.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <?php if (! empty(trim($__env->yieldContent('back')))): ?>
                            <div class="col-auto">
                                <a href="<?php echo $__env->yieldContent('back'); ?>" class="btn btn-secondary"><i
                                        class="fas fa-arrow-left fa-rtl me-2"></i><?php echo e(translate('Back')); ?></a>
                            </div>
                        <?php endif; ?>
                        <?php if(request()->routeIs('admin.dashboard')): ?>
                            <div class="col-auto">
                                <div class="dropdown">
                                    <button class="btn btn-secondary dropdown-toggle" type="button" id="quickAccess"
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                        <?php echo e(translate('Quick Access')); ?>

                                    </button>
                                    <ul class="dropdown-menu" aria-labelledby="quickAccess">
                                        <li>
                                            <a class="dropdown-item"
                                                href="<?php echo e(route('admin.settings.language.index')); ?>">
                                                <?php echo e(translate('Language')); ?>

                                            </a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="<?php echo e(route('admin.settings.general')); ?>">
                                                <?php echo e(translate('General Settings')); ?>

                                            </a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item"
                                                href="<?php echo e(route('admin.settings.mail-templates.index')); ?>">
                                                <?php echo e(translate('Mail Templates')); ?>

                                            </a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item"
                                                href="<?php echo e(route('admin.financial.payment-gateways.index')); ?>">
                                                <?php echo e(translate('Payment Gateways')); ?>

                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
        <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <?php echo $__env->make('admin.includes.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

</html>
<?php /**PATH /Users/vironeer/Desktop/Workspace/market/resources/views/admin/layouts/app.blade.php ENDPATH**/ ?>