<?php $__env->startSection('section', translate('System')); ?>
<?php $__env->startSection('title', translate('Maintenance Mode')); ?>
<?php $__env->startSection('container', 'container-max-lg'); ?>
<?php $__env->startSection('content'); ?>
    <form id="vironeer-submited-form" action="<?php echo e(route('admin.system.maintenance')); ?>" method="POST"
        enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="alert alert-warning" role="alert">
            <strong><?php echo e(translate('Note!')); ?></strong>
            <span><?php echo e(translate('As an admin, you can still view and control your website but the visitors will redirect to the maintenance page.')); ?></span>
        </div>
        <div class="card mb-3">
            <div class="card-body p-4">
                <div class="row g-4">
                    <div class="col-12">
                        <div class="col-lg-4">
                            <label class="form-label"><?php echo e(translate('Status')); ?></label>
                            <input type="checkbox" name="maintenance[status]" data-toggle="toggle" data-height="40px"
                                <?php echo e(@$settings->maintenance->status ? 'checked' : ''); ?>>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="image-box p-4 border bg-light rounded-2">
                            <h5><?php echo e(translate('Icon')); ?></h5>
                            <div class="my-3">
                                <img id="image-preview-0" class="border p-2 rounded-2 bg-light"
                                    src="<?php echo e(asset(@$settings->maintenance->icon)); ?>" alt="<?php echo e(translate('Image')); ?>"
                                    height="60px">
                            </div>
                            <input type="file" name="maintenance[icon]" class="form-control form-control-md image-input"
                                data-id="0" accept=".jpg,.jpeg,.png,.svg">
                            <div class="form-text mt-2">
                                <?php echo e(translate('Supported (JPEG, JPG, PNG, SVG)')); ?>

                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <label class="form-label"><?php echo e(translate('Title')); ?></label>
                        <input name="maintenance[title]" class="form-control form-control-md"
                            value="<?php echo e(@$settings->maintenance->title); ?>">
                    </div>
                    <div class="col-12">
                        <label class="form-label"><?php echo e(translate('Body')); ?></label>
                        <textarea name="maintenance[body]" class="form-control" rows="8"><?php echo e(@$settings->maintenance->body); ?></textarea>
                    </div>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/vironeer/Desktop/Workspace/market/resources/views/admin/system/maintenance.blade.php ENDPATH**/ ?>