<?php if($bestSellingItemsSection && $bestSellingItems->count() > 0): ?>
    <div class="section section-start">
        <div class="container container-custom">
            <div class="section-header">
                <div class="row row-cols-auto align-items-center justify-content-center justify-content-lg-between g-3">
                    <div class="col">
                        <div class="section-title mb-0">
                            <h2 class="section-title-text"><?php echo e($bestSellingItemsSection->name); ?></h2>
                            <div class="section-title-divider"></div>
                        </div>
                        <?php if($bestSellingItemsSection->description): ?>
                            <p class="section-text mt-3"><?php echo e($bestSellingItemsSection->description); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="col d-none d-lg-block">
                        <a href="<?php echo e(route('items.index', ['best_selling' => 'true'])); ?>">
                            <?php echo e(translate('View All')); ?>

                            <i class="fa fa-chevron-right fa-sm fa-rtl ms-2"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="section-body">
                <div class="row row-cols-1 row-cols-md-2 row-cols-lg-2 row-cols-xxl-4 g-3">
                    <?php $__currentLoopData = $bestSellingItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bestSellingItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col" data-aos="fade-up" data-aos-duration="1000">
                            <?php echo $__env->make('themes.basic.partials.item', ['item' => $bestSellingItem], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="text-center mt-5 d-block d-lg-none">
                    <a href="<?php echo e(route('items.index', ['best_selling' => true])); ?>" class="btn btn-primary btn-md">
                        <?php echo e(translate('View All')); ?>

                        <i class="fa fa-arrow-right fa-rtl ms-2"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /Users/vironeer/Desktop/Workspace/market/resources/views/themes/basic/sections/best-selling-items.blade.php ENDPATH**/ ?>