<?php $__env->startSection('section', translate('System')); ?>
<?php $__env->startSection('title', translate('System Information')); ?>
<?php $__env->startSection('container', 'container-max-lg'); ?>
<?php $__env->startSection('content'); ?>
    <div class="card mb-4">
        <div class="card-header bg-primary text-white border-bottom-0"><i
                class="fas fa-folder me-2"></i><?php echo e(translate('Application')); ?></div>
        <ul class="custom-list-group system list-group list-group-flush">
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <strong><?php echo e(translate('Name')); ?></strong>
                <span class="capitalize"><?php echo e(str_replace('_', ' ', $system->application->name)); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                <strong><?php echo e(translate('Version')); ?></strong>
                <span>v<?php echo e($system->application->version); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center ">
                <strong><?php echo e(translate('Laravel Version')); ?></strong>
                <span>v<?php echo e($system->application->laravel); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                <strong><?php echo e(translate('Timezone')); ?></strong>
                <span class="capitalize"><?php echo e($system->application->timezone); ?></span>
            </li>
        </ul>
    </div>
    <div class="card mb-4">
        <div class="card-header bg-lg-5 text-white border-bottom-0"><i
                class="fas fa-server me-2"></i><?php echo e(translate('Server Details')); ?></div>
        <ul class="custom-list-group system list-group list-group-flush">
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <strong><?php echo e(translate('Software')); ?></strong>
                <span><?php echo e($system->server->SERVER_SOFTWARE); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                <strong><?php echo e(translate('PHP Version')); ?></strong>
                <span>v<?php echo e($system->server->php); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <strong><?php echo e(translate('IP Address')); ?></strong>
                <span><?php echo e($system->server->SERVER_ADDR); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                <strong><?php echo e(translate('Protocol')); ?></strong>
                <span><?php echo e($system->server->SERVER_PROTOCOL); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <strong><?php echo e(translate('HTTP Host')); ?></strong>
                <span><?php echo e($system->server->HTTP_HOST); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                <strong><?php echo e(translate('Port')); ?></strong>
                <span><?php echo e($system->server->SERVER_PORT); ?></span>
            </li>
        </ul>
    </div>
    <div class="card">
        <div class="card-header bg-lg-5 text-white border-bottom-0"><i
                class="fas fa-database me-2"></i><?php echo e(translate('System Cache')); ?></div>
        <ul class="custom-list-group system list-group list-group-flush">
            <li class="list-group-item">
                <i class="far fa-check-circle me-2 text-success"></i>
                <span><?php echo e(translate('Compiled views will be cleared')); ?></span>
            </li>
            <li class="list-group-item">
                <i class="far fa-check-circle me-2 text-success"></i>
                <span><?php echo e(translate('Application cache will be cleared')); ?></span>
            </li>
            <li class="list-group-item">
                <i class="far fa-check-circle me-2 text-success"></i>
                <span><?php echo e(translate('Route cache will be cleared')); ?></span>
            </li>
            <li class="list-group-item">
                <i class="far fa-check-circle me-2 text-success"></i>
                <span><?php echo e(translate('Configuration cache will be cleared')); ?></span>
            </li>
            <li class="list-group-item">
                <i class="far fa-check-circle me-2 text-success"></i>
                <span><?php echo e(translate('All Other Caches will be cleared')); ?></span>
            </li>
            <li class="list-group-item">
                <i class="far fa-check-circle me-2 text-success"></i>
                <span><?php echo e(translate('Error logs file will be cleared')); ?></span>
            </li>
            <li class="list-group-item p-0"></li>
        </ul>
        <div class="card-body">
            <a href="<?php echo e(route('admin.system.info.cache')); ?>" class="btn btn-danger btn-lg w-100 action-confirm">
                <i class="fa-solid fa-broom"></i>
                <?php echo e(translate('Clear System Cache')); ?>

            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.grid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/vironeer/Desktop/Workspace/market/resources/views/admin/system/info.blade.php ENDPATH**/ ?>