<?php $__env->startSection('section', translate('Settings')); ?>
<?php $__env->startSection('title', translate('Storage Settings')); ?>
<?php $__env->startSection('container', 'container-max-lg'); ?>
<?php $__env->startSection('content'); ?>
    <form id="vironeer-submited-form" action="<?php echo e(route('admin.settings.storage.update')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="card mb-4">
            <div class="card-header">
                <?php echo e(translate('Storage Provider')); ?>

            </div>
            <div class="card-body p-4">
                <div class="row g-3 mb-3">
                    <div class="col-12">
                        <label class="form-label"><?php echo e(translate('Storage Provider')); ?></label>
                        <select id="storage-provider" name="storage_provider" class="form-select form-select-md">
                            <?php $__currentLoopData = $storageProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $storageProvider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($storageProvider->alias); ?>"
                                    <?php echo e($storageProvider->isDefault() ? 'selected' : ''); ?>><?php echo e($storageProvider->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <?php $__currentLoopData = $storageProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $storageProvider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(!$storageProvider->isLocal()): ?>
                            <?php if($storageProvider->credentials): ?>
                                <?php $__currentLoopData = $storageProvider->credentials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div
                                        class="col-12 credentials credential-<?php echo e($storageProvider->alias); ?> <?php echo e(!$storageProvider->isDefault() ? 'd-none' : ''); ?>">
                                        <label class="form-label capitalize">
                                            <?php echo e(str_replace('_', ' ', $key)); ?> :
                                        </label>
                                        <input type="text"
                                            name="credentials[<?php echo e($storageProvider->alias); ?>][<?php echo e($key); ?>]"
                                            value="<?php echo e(demo($value)); ?>" class="form-control form-control-md remove-spaces">
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="alert alert-primary mb-0">
                    <i class="fa-regular fa-circle-question me-1"></i>
                    <?php echo e(translate('When you change the storage provider, you must move all files form those paths to new storage provider.')); ?>

                    <div class="mt-2">
                        <h6><?php echo e(translate('Local')); ?></h6>
                        <ul>
                            <li><strong>public/images/editor/</strong></li>
                            <li><strong>public/images/items/</strong></li>
                            <li><strong>public/files/items/</strong></li>
                            <li><strong>storage/app/files/</strong></li>
                            <li class="mb-0"><strong>storage/app/files/items/</strong></li>
                        </ul>
                        <h6><?php echo e(translate('s3 and others')); ?></h6>
                        <ul class="mb-0">
                            <li><strong>images/editor/</strong></li>
                            <li><strong>images/items/</strong></li>
                            <li><strong>files/items/</strong></li>
                            <li><strong>files/</strong></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <?php if(config('filesystems.default') != 'local'): ?>
        <div class="card">
            <div class="card-header">
                <?php echo e(translate('Test Storage Connection')); ?>

            </div>
            <div class="card-body p-4">
                <form action="<?php echo e(route('admin.settings.storage.test')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button class="btn btn-dark btn-lg w-100"><?php echo e(translate('Test Connection')); ?></button>
                </form>
            </div>
        </div>
    <?php endif; ?>
    <?php $__env->startPush('scripts'); ?>
        <script>
            "use strict";
            let storageProvider = $('#storage-provider');
            storageProvider.on('change', function() {
                let storageProviderValue = $(this).val();
                $('.credentials').addClass('d-none');
                $('.credential-' + storageProviderValue).removeClass('d-none');
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/vironeer/Desktop/Workspace/market/resources/views/admin/settings/storage.blade.php ENDPATH**/ ?>