<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="icon" href="<?php echo e(asset('vendor/installer/img/favicon.ico')); ?>" type="image/png" />
    <title><?php echo e(installer_trans('Vironeer Installer')); ?> - <?php echo $__env->yieldContent('title'); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset('vendor/libs/bootstrap/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('vendor/libs/fontawesome/fontawesome.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('vendor/installer/css/app.min.css')); ?>" />
</head>

<body>
    <nav class="vironeer-navbar">
        <div class="container">
            <div class="vironeer-navbar-inner">
                <a href="https://vironeer.com" class="vironeer-logo" target="_blank">
                    <img src="<?php echo e(asset('vendor/installer/img/logo.png')); ?>" alt="Vironeer" />
                </a>
                <div class="vironeer-navbar-actions">
                    <a href="https://t.me/vironeer" class="btn btn-light btn-md"
                        target="_blank"><?php echo e(installer_trans('Get Help')); ?></a>
                </div>
            </div>
        </div>
    </nav>
    <div class="vironeer-section mt-auto">
        <div class="container">
            <div class="vironeer-section-inner">
                <div class="vironeer-section-body">
                    <?php if($errors->any()): ?>
                        <div class="col-xxl-8 mx-auto">
                            <div class="alert alert-danger mb-3">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="vironeer-steps col-xxl-8 mx-auto">
                        <div class="vironeer-steps-header">
                            <div class="vironeer-steps-item <?php echo e(currentStep(1)); ?>">
                                <div class="vironeer-steps-item-icon">
                                    <i class="fas fa-check"></i>
                                    <div class="vironeer-steps-item-number">1</div>
                                </div>
                                <div class="vironeer-steps-item-text"><?php echo e(installer_trans('Requirements')); ?></div>
                            </div>
                            <div class="vironeer-steps-item <?php echo e(currentStep(2)); ?>">
                                <div class="vironeer-steps-item-icon">
                                    <i class="fas fa-check"></i>
                                    <div class="vironeer-steps-item-number">2</div>
                                </div>
                                <div class="vironeer-steps-item-text"><?php echo e(installer_trans('Permissions')); ?></div>
                            </div>
                            <div class="vironeer-steps-item <?php echo e(currentStep(3)); ?>">
                                <div class="vironeer-steps-item-icon">
                                    <i class="fas fa-check"></i>
                                    <div class="vironeer-steps-item-number">3</div>
                                </div>
                                <div class="vironeer-steps-item-text"><?php echo e(installer_trans('License')); ?></div>
                            </div>
                            <div class="vironeer-steps-item <?php echo e(currentStep(4)); ?>">
                                <div class="vironeer-steps-item-icon">
                                    <i class="fas fa-check"></i>
                                    <div class="vironeer-steps-item-number">4</div>
                                </div>
                                <div class="vironeer-steps-item-text"><?php echo e(installer_trans('Database')); ?></div>
                            </div>
                            <div class="vironeer-steps-item <?php echo e(currentStep(5)); ?>">
                                <div class="vironeer-steps-item-icon">
                                    <i class="fas fa-check"></i>
                                    <div class="vironeer-steps-item-number">5</div>
                                </div>
                                <div class="vironeer-steps-item-text"><?php echo e(installer_trans('Import')); ?></div>
                            </div>
                            <div class="vironeer-steps-item <?php echo e(currentStep(6)); ?>">
                                <div class="vironeer-steps-item-icon">
                                    <i class="fas fa-check"></i>
                                    <div class="vironeer-steps-item-number">6</div>
                                </div>
                                <div class="vironeer-steps-item-text"><?php echo e(installer_trans('Completed')); ?></div>
                            </div>
                        </div>
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <footer class="vironeer-footer mt-auto">
        <div class="container">
            <div class="row justify-content-sm-between align-items-center g-3">
                <div class="col-12 col-sm-auto">
                    <p class="text-muted text-center mb-0 small">
                        <?php echo e(installer_trans('Vironeer')); ?> © <span data-year></span> -
                        <?php echo e(installer_trans('All rights reserved')); ?>

                    </p>
                </div>
                <div class="col-12 col-sm-auto">
                    <div class="vironeer-footer-links">
                        <a href="https://codecanyon.net/user/vironeer" target="_blank"
                            class="link"><?php echo e(installer_trans('Envato')); ?></a>
                        <a href="https://twitter.com/vironeer" target="_blank"
                            class="link"><?php echo e(installer_trans('Twitter')); ?></a>
                        <a href="https://t.me/vironeer" target="_blank"
                            class="link"><?php echo e(installer_trans('Get Help')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <script src="<?php echo e(asset('vendor/libs/jquery/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/libs/bootstrap/bootstrap.bundle.min.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
    <script>
        "use strict";
        document.querySelectorAll("[data-year]").forEach((el) => {
            el.textContent = new Date().getFullYear();
        });
        $(".remove-spaces").on('input', function() {
            $(this).val($(this).val().replace(/\s/g, ""));
        });
    </script>
</body>

</html>
<?php /**PATH /Users/vironeer/Desktop/Workspace/market/vironeer/installer/resources/views/layouts/app.blade.php ENDPATH**/ ?>