@extends('themes.basic.workspace.layouts.app')
@section('title', translate('Purchases'))
@section('breadcrumbs', Breadcrumbs::render('workspace.purchases'))
@section('content')
    <div class="dashboard-card card-v p-0">
        @if ($purchases->count() > 0 || request()->input('search'))
            <div class="table-search p-4">
                <form action="{{ url()->current() }}" method="GET">
                    <div class="form-search">
                        <button class="icon">
                            <i class="fa fa-search"></i>
                        </button>
                        <input type="text" name="search" placeholder="{{ translate('Search...') }}"
                            class="form-control form-control-md" value="{{ request('search') }}">
                    </div>
                </form>
            </div>
            <div class="overflow-hidden">
                <div class="table-container">
                    <table class="dashboard-table table text-start table-borderless">
                        <thead>
                            <tr>
                                <th>{{ translate('ID') }}</th>
                                <th>{{ translate('Details') }}</th>
                                <th class="text-center">{{ translate('License Type') }}</th>
                                @if (@$settings->item->support_status)
                                    <th class="text-center">{{ translate('Support Expiry Date') }}</th>
                                @endif
                                <th class="text-center">{{ translate('Purchase Date') }}</th>
                                <th class="text-center">{{ translate('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($purchases as $purchase)
                                @php
                                    $item = $purchase->item;
                                @endphp
                                <tr>
                                    <td><i class="fa-solid fa-hashtag me-1"></i>{{ $purchase->id }}</td>
                                    <td class="text-start">
                                        <div class="d-flex align-items-center">
                                            <a href="{{ $item->getLink() }}" class="item-img item-img-sm me-3">
                                                <img src="{{ $item->isDeleted() ? asset('images/onerror-image.png') : $item->getThumbnailLink() }}"
                                                    alt="{{ $item->name }}">
                                            </a>
                                            <div>
                                                <a href="{{ $item->getLink() }}" class="table-name text-dark d-block">
                                                    {{ $item->name }}
                                                </a>
                                                @if (@$settings->item->reviews_status && !$item->isDeleted())
                                                    <div class="mt-2">
                                                        <div class="row g-2 row-cols-auto align-items-center">
                                                            <div class="col">
                                                                @include(
                                                                    'themes.basic.partials.rating-stars',
                                                                    [
                                                                        'stars' => $purchase->review
                                                                            ? $purchase->review->stars
                                                                            : 0,
                                                                    ]
                                                                )
                                                            </div>
                                                            <div class="col">
                                                                <a href="{{ $item->getReviewsLink() }}">
                                                                    <small>({{ translate('Write a review') }})</small>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        @if ($purchase->isLicenseTypeRegular())
                                            <div class="badge bg-gray rounded-2 fw-light px-3 py-2">
                                                {{ translate('Regular') }}
                                            </div>
                                        @else
                                            <div class="badge bg-primary rounded-2 fw-light px-3 py-2">
                                                {{ translate('Extended') }}
                                            </div>
                                        @endif
                                    </td>
                                    @if (@$settings->item->support_status)
                                        <td class="text-center">
                                            @if ($purchase->support_expiry_at)
                                                <div class="{{ $purchase->isSupportExpired() ? 'text-danger' : '' }}">
                                                    {{ dateFormat($purchase->support_expiry_at) }}</div>
                                                @if (
                                                    @$settings->item->support_status &&
                                                        $item->isSupported() &&
                                                        $purchase->isSupportExpired() &&
                                                        $item->isPurchasingEnabled())
                                                    <button class="btn btn-outline-danger btn-sm mt-2 support-extend"
                                                        data-action="{{ route('workspace.purchases.support.extend', $purchase->id) }}">
                                                        {{ translate('Extend Support') }}
                                                    </button>
                                                @endif
                                            @else
                                                @if ($settings->item->support_status && $item->isSupported() && $item->isPurchasingEnabled())
                                                    <button class="btn btn-outline-primary btn-sm support-purchase"
                                                        data-action="{{ route('workspace.purchases.support.purchase', $purchase->id) }}">
                                                        {{ translate('Buy Support') }}
                                                    </button>
                                                @else
                                                    <span>--</span>
                                                @endif
                                            @endif
                                        </td>
                                    @endif
                                    <td class="text-center">
                                        {{ dateFormat($purchase->created_at) }}
                                    </td>
                                    <td class="text-center">
                                        @if ($item->isDeleted())
                                            <span class="badge bg-danger rounded-2 fw-light px-3 py-2">
                                                {{ translate('Deleted') }}
                                            </span>
                                        @else
                                            <div class="dropdown custom-drop ">
                                                <a class="btn btn-outline-secondary dropdown-toggle" href="#"
                                                    role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                    {{ translate('Action') }}
                                                </a>
                                                <ul class="dropdown-menu border-0 shadow-sm">
                                                    <li>
                                                        @if ($item->isMainFileExternal())
                                                            <a href="{{ $item->main_file }}" target="_blank"
                                                                class="dropdown-item">
                                                                {{ translate('Download') }}
                                                            </a>
                                                        @else
                                                            <a class="dropdown-item"
                                                                href="{{ route('workspace.purchases.download', $purchase->id) }}">
                                                                {{ translate('Download') }}
                                                            </a>
                                                        @endif
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item item-purchase-code" href="#"
                                                            data-purchase-code="{{ $purchase->code }}">
                                                            {{ translate('Purchase code') }}
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" target="_blank"
                                                            href="{{ route('workspace.purchases.license', $purchase->id) }}">
                                                            {{ translate('License Certificate') }}
                                                        </a>
                                                    </li>
                                                    @if (@$settings->actions->refunds)
                                                        <li>
                                                            <a class="dropdown-item"
                                                                href="{{ route('workspace.refunds.create', ['purchase' => $purchase->id]) }}">
                                                                {{ translate('Request a refund') }}
                                                            </a>
                                                        </li>
                                                    @endif
                                                    @if (@$settings->item->reviews_status && !$item->isDeleted())
                                                        <li>
                                                            <a class="dropdown-item" href="{{ $item->getReviewsLink() }}">
                                                                {{ translate('Write a review') }}
                                                            </a>
                                                        </li>
                                                    @endif
                                                </ul>
                                            </div>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center">
                                        <div class="text-muted p-4">{{ translate('No data found') }}</div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        @else
            <div class="dashboard-card-empty pd">
                <div class="py-4">
                    <div class="mb-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="200px" height="200px"
                            viewBox="0 0 803.05238 591.37509" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <path
                                d="M997.07789,189.37527H202.92213a4.45318,4.45318,0,0,1-4.44832-4.44831v-26.1662a4.45318,4.45318,0,0,1,4.44832-4.44831H997.07789a4.45317,4.45317,0,0,1,4.4483,4.44831V184.927A4.45318,4.45318,0,0,1,997.07789,189.37527Z"
                                transform="translate(-198.47381 -154.31245)" fill="#e4e4e4" />
                            <circle id="a35e044f-57c7-4e60-ba2c-0b63f07d3a91"
                                data-name="a7a88a4d-66b2-4c09-a29b-e65e87e57a01" cx="25.81549" cy="16.25512" r="6.3155"
                                fill="#fff" />
                            <circle id="b8ca9947-3ca9-4995-aa34-7c8526cbf832"
                                data-name="ecd091ab-fa27-42b2-b94f-bd1073aab054" cx="49.78705" cy="16.25512" r="6.3155"
                                fill="#fff" />
                            <circle id="a31b64b8-966e-40be-99c3-e775622dac5b"
                                data-name="a332723e-32dc-4e13-8ae5-d2643a7feb7f" cx="73.75972" cy="16.25512" r="6.3155"
                                fill="#fff" />
                            <path
                                d="M973.59083,166.2207H945.9867a2.04475,2.04475,0,0,1,0-4.08949h27.60413a2.04475,2.04475,0,0,1,.00769,4.08949Z"
                                transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            <path
                                d="M973.59083,173.88852H945.9867a2.04475,2.04475,0,0,1,0-4.08949h27.60413a2.04475,2.04475,0,0,1,.00769,4.08949Z"
                                transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            <path
                                d="M973.59083,181.55634H945.9867a2.04475,2.04475,0,0,1,0-4.0895h27.60413a2.04475,2.04475,0,0,1,.00769,4.0895Z"
                                transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            <path
                                d="M424.91688,674.27641c2.92224-23.4981,17.48511-46.65063,39.89523-54.29754a109.09788,109.09788,0,0,0,.0054,74.90374c3.44358,9.31476,8.24353,19.31641,5.0044,28.70429-2.01535,5.84137-6.94565,10.31055-12.4567,13.105-5.51141,2.79443-11.6279,4.12634-17.66788,5.43158l-1.18869.98315C428.9203,721.45561,421.99464,697.77458,424.91688,674.27641Z"
                                transform="translate(-198.47381 -154.31245)" fill="#f0f0f0" />
                            <path
                                d="M465.03449,620.4232a93.25009,93.25009,0,0,0-23.18185,52.4812,40.15631,40.15631,0,0,0,.45679,12.57361,23.03162,23.03162,0,0,0,5.72827,10.68256c2.58185,2.83667,5.5513,5.43933,7.39865,8.85425a14.10232,14.10232,0,0,1,.689,11.51263c-1.631,4.678-4.84564,8.491-8.11886,12.11054-3.63428,4.01879-7.47284,8.13549-9.0177,13.46337-.1872.64557-1.17789.31739-.991-.32721,2.68777-9.26959,11.68607-14.53485,15.97736-22.88385,2.00238-3.89581,2.84286-8.41864.96566-12.531-1.64154-3.59613-4.70135-6.28259-7.34039-9.1322a24.57672,24.57672,0,0,1-5.9902-10.23658,37.12347,37.12347,0,0,1-.93851-12.50964,90.469,90.469,0,0,1,6.60736-27.49286A94.90381,94.90381,0,0,1,464.344,619.64061c.44623-.4997,1.13385.28632.69055.78271Z"
                                transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            <path
                                d="M442.13355,666.58873A13.99051,13.99051,0,0,1,431.484,651.93315a.52227.52227,0,0,1,1.0426.05206,12.95492,12.95492,0,0,0,9.93414,13.61249C443.11408,665.753,442.78315,666.74315,442.13355,666.58873Z"
                                transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            <path
                                d="M446.53916,694.89464a26.96549,26.96549,0,0,0,12.04175-15.53015c.18945-.64484,1.18024-.3169.991.32721a28.04826,28.04826,0,0,1-12.56339,16.13507C446.42982,696.17,445.9636,695.23607,446.53916,694.89464Z"
                                transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            <path
                                d="M452.33448,637.95433a7.91916,7.91916,0,0,0,7.50482-.381c.57407-.35046,1.03971.584.46936.93213a8.87421,8.87421,0,0,1-8.30139.43988.53934.53934,0,0,1-.33191-.65912A.52444.52444,0,0,1,452.33448,637.95433Z"
                                transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            <path
                                d="M533.12128,661.94939c-.35223.229-.70446.458-1.05712.69586a104.2919,104.2919,0,0,0-13.335,10.411c-.326.29071-.652.59015-.969.88965a109.94776,109.94776,0,0,0-23.87842,32.68658,106.77244,106.77244,0,0,0-5.84863,15.13214c-2.15814,7.16095-3.92835,15.09687-8.20032,20.95423a18.31835,18.31835,0,0,1-1.427,1.76159H439.80021c-.08774-.044-.1759-.07928-.26407-.12335l-1.54141.0705c.06192-.273.132-.55493.194-.82794.03528-.15857.07913-.31708.11441-.47565.02624-.10571.05289-.21143.07052-.30829.00861-.03522.01764-.07043.02625-.09686.01764-.09687.04431-.185.06192-.27307q.58122-2.365,1.19778-4.72992c0-.00885,0-.00885.00861-.01764a156.9946,156.9946,0,0,1,13.212-34.686c.17633-.32586.35223-.66058.5462-.98651a101.88533,101.88533,0,0,1,9.15164-13.88147,90.0712,90.0712,0,0,1,5.99832-6.86145,74.90082,74.90082,0,0,1,18.74329-14.04c13.84637-7.31067,29.87671-10.11157,44.67444-5.64593C532.37254,661.71165,532.74284,661.8261,533.12128,661.94939Z"
                                transform="translate(-198.47381 -154.31245)" fill="#f0f0f0" />
                            <path
                                d="M533.03452,662.43938A93.24986,93.24986,0,0,0,482.9278,690.3856a40.1569,40.1569,0,0,0-7.20544,10.31434,23.03161,23.03161,0,0,0-1.858,11.97827c.35357,3.81939,1.15756,7.68524.57657,11.52411a14.10252,14.10252,0,0,1-6.38129,9.607c-4.11878,2.75317-8.98114,3.86218-13.77384,4.7815-5.32138,1.02069-10.86477,1.99658-15.306,5.32049-.53812.40271-1.13157-.45581-.59427-.85791,7.727-5.783,18.08166-4.56946,26.53466-8.652,3.94434-1.905,7.33847-5.01019,8.31559-9.424.85443-3.85962.02877-7.84686-.36267-11.711a24.57678,24.57678,0,0,1,1.38028-11.77984,37.12469,37.12469,0,0,1,6.78231-10.55329,90.47,90.47,0,0,1,21.82822-17.97345,94.90373,94.90373,0,0,1,30.09042-11.56115c.65714-.13031.73294.91125.08011,1.04071Z"
                                transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            <path
                                d="M486.95457,685.512a13.99047,13.99047,0,0,1,.32061-18.1134c.44547-.50245,1.24717.16619.80109.66931a12.95487,12.95487,0,0,0-.26379,16.84985C488.24061,685.43517,487.38026,686.02647,486.95457,685.512Z"
                                transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            <path
                                d="M473.43006,710.76518a26.96573,26.96573,0,0,0,18.96488-5.15c.53952-.40082,1.13311.45758.59426.85791a28.04838,28.04838,0,0,1-19.74557,5.319C472.5749,711.7177,472.765,710.69127,473.43006,710.76518Z"
                                transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            <path
                                d="M512.3393,668.7907a7.91928,7.91928,0,0,0,6.22156,4.21423c.66934.06579.47855,1.09222-.18643,1.02685a8.87419,8.87419,0,0,1-6.893-4.64679.53933.53933,0,0,1,.13181-.72607.52444.52444,0,0,1,.7261.13184Z"
                                transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            <path
                                d="M458.76688,336.75688H331.0413a14.90431,14.90431,0,0,1-14.88721-14.88769V252.30374A14.90346,14.90346,0,0,1,331.0413,237.417H458.76688a14.90347,14.90347,0,0,1,14.88721,14.88672v69.56543A14.90431,14.90431,0,0,1,458.76688,336.75688Z"
                                transform="translate(-198.47381 -154.31245)" fill="#e6e6e6" />
                            <path
                                d="M653.76688,336.75688H526.0413a14.90431,14.90431,0,0,1-14.88721-14.88769V252.30374A14.90346,14.90346,0,0,1,526.0413,237.417H653.76688a14.90345,14.90345,0,0,1,14.88721,14.88672v69.56543A14.90433,14.90433,0,0,1,653.76688,336.75688Z"
                                transform="translate(-198.47381 -154.31245)"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                            <path
                                d="M848.76688,336.75688H721.0413a14.90431,14.90431,0,0,1-14.88721-14.88769V252.30374A14.90346,14.90346,0,0,1,721.0413,237.417H848.76688a14.90345,14.90345,0,0,1,14.88721,14.88672v69.56543A14.90433,14.90433,0,0,1,848.76688,336.75688Z"
                                transform="translate(-198.47381 -154.31245)" fill="#e6e6e6" />
                            <path
                                d="M458.76688,491.75688H331.0413a14.90431,14.90431,0,0,1-14.88721-14.88769V407.30376A14.90349,14.90349,0,0,1,331.0413,392.417H458.76688a14.90348,14.90348,0,0,1,14.88721,14.88672v69.56543A14.90431,14.90431,0,0,1,458.76688,491.75688Z"
                                transform="translate(-198.47381 -154.31245)" fill="#f2f2f2" />
                            <path
                                d="M653.76688,491.75688H526.0413a14.90431,14.90431,0,0,1-14.88721-14.88769V407.30376A14.90349,14.90349,0,0,1,526.0413,392.417H653.76688a14.90346,14.90346,0,0,1,14.88721,14.88672v69.56543A14.90433,14.90433,0,0,1,653.76688,491.75688Z"
                                transform="translate(-198.47381 -154.31245)" fill="#e6e6e6" />
                            <g id="e3e4f7c8-e232-44d3-85d4-7e764218aef0" data-name="aa405d94-515b-444f-88dd-2c52df39214d">
                                <circle id="fcc64bf3-a6e1-406f-af2a-c5c9529d985b"
                                    data-name="ede3a9f0-5e02-4455-ac7e-751a5f8c3692" cx="464.31155" cy="327.43306"
                                    r="22.81223" fill="{{ $themeSettings->colors->primary_color }}" />
                                <path id="a515bf60-7ad9-4961-925b-281b4504c434-115"
                                    data-name="ba039ca8-d148-45ed-9781-bacb7304e881"
                                    d="M672.25828,479.82985h-7.75611v-7.75613a1.82507,1.82507,0,0,0-1.82507-1.82511h0a1.82508,1.82508,0,0,0-1.82507,1.82511v7.75613h-7.75611a1.82507,1.82507,0,0,0-1.82507,1.8251h0a1.82508,1.82508,0,0,0,1.82507,1.82511h7.75617v7.75613a1.82507,1.82507,0,0,0,1.82507,1.8251h0a1.82508,1.82508,0,0,0,1.82508-1.82507V483.48h7.756a1.82508,1.82508,0,0,0,1.82507-1.82511h0a1.82507,1.82507,0,0,0-1.82507-1.8251h0Z"
                                    transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            </g>
                            <g id="e103fff6-fe82-4519-942e-bf1bf1b0aca3" data-name="bbf41f8a-587e-4352-8304-6d86282586e3">
                                <circle id="add300b1-303e-47da-8a54-54886e1d1e76"
                                    data-name="e4c91425-bc08-43ed-9b2d-9a6452dd6ab0" cx="662.31155" cy="176.43306"
                                    r="22.81224" fill="{{ $themeSettings->colors->primary_color }}" />
                                <path id="ac71a829-1528-4702-ba68-9cb7b8b12af7-116"
                                    data-name="b08e8960-896e-4763-a2dc-6c3da3e5d175"
                                    d="M870.25828,328.82985h-7.75611v-7.75613a1.82507,1.82507,0,0,0-1.82507-1.82511h0a1.82508,1.82508,0,0,0-1.82507,1.82511v7.75613h-7.75611a1.82507,1.82507,0,0,0-1.82507,1.8251h0a1.82508,1.82508,0,0,0,1.82507,1.82511h7.75617v7.75613a1.82507,1.82507,0,0,0,1.82507,1.8251h0a1.82508,1.82508,0,0,0,1.82508-1.82507V332.48h7.756a1.82508,1.82508,0,0,0,1.82507-1.82511h0a1.82507,1.82507,0,0,0-1.82507-1.8251h0Z"
                                    transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            </g>
                            <g id="eec1f109-4866-4d4c-80db-d160015753dd" data-name="b77ad267-181d-433f-b31f-af61e58bf4a6">
                                <circle id="ad2802dd-75a3-400f-a980-dd7e255328e3"
                                    data-name="e8aef769-5476-47e9-8295-ae809767f9aa" cx="269.31155" cy="174.43306"
                                    r="22.81223" fill="{{ $themeSettings->colors->primary_color }}" />
                                <path id="a152d324-d2c4-475a-92fe-001d0469b5e0-117"
                                    data-name="efbebd4e-dbd2-4103-8d2c-f0ca8346a3bf"
                                    d="M477.25828,326.82985h-7.75614v-7.75613a1.82509,1.82509,0,0,0-1.82507-1.82511h0a1.8251,1.8251,0,0,0-1.8251,1.82511h0v7.75613h-7.75614a1.8251,1.8251,0,0,0-1.8251,1.8251h0a1.8251,1.8251,0,0,0,1.82507,1.82511h7.75614v7.75613a1.82509,1.82509,0,0,0,1.8251,1.8251h0a1.82508,1.82508,0,0,0,1.8251-1.82507V330.48h7.75614a1.8251,1.8251,0,0,0,1.8251-1.82511h0a1.8251,1.8251,0,0,0-1.8251-1.8251h0Z"
                                    transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            </g>
                            <path
                                d="M638.57566,297.23225a9.06978,9.06978,0,0,1-7.3208,11.82447l-10.54828,72.00079-17.303-8.451,17.40372-71.8703a9.11882,9.11882,0,0,1,17.76831-3.504Z"
                                transform="translate(-198.47381 -154.31245)" fill="#9e616a" />
                            <path
                                d="M512.5893,527.83214a9.06961,9.06961,0,0,0-3.492-13.46173l7.11621-76.58634-14.90473,7.63986-4.654,73.80091a9.11882,9.11882,0,0,0,15.93442,8.6073Z"
                                transform="translate(-198.47381 -154.31245)" fill="#9e616a" />
                            <polygon
                                points="324.298 334.784 388.259 332.324 391.949 265.903 318.148 265.903 324.298 334.784"
                                fill="#9e616a" />
                            <polygon
                                points="312.427 569.355 323.357 569.354 328.556 527.197 312.425 527.197 312.427 569.355"
                                fill="#9e616a" />
                            <path
                                d="M508.18961,718.27562l17.27774-1.03125v7.40253l16.42643,11.34466a4.6239,4.6239,0,0,1-2.62748,8.429H518.69651l-3.5455-7.32221-1.38434,7.32221h-7.75561Z"
                                transform="translate(-198.47381 -154.31245)" fill="#2f2e41" />
                            <polygon
                                points="361.041 569.355 371.971 569.354 377.17 527.197 361.039 527.197 361.041 569.355"
                                fill="#9e616a" />
                            <path
                                d="M521.88435,473.5041s-19.13755,15.45038-8.76307,70.62845c-1.5798.1883.20908,3.30231.20908,3.30231l1.497,44.95953,1.15683,5.1529-3.84607,8.31463,1.58551,9.034-4.888,81.9917,18.05719,2.33508L544.173,614.07915l3.2909-9.57257,3.3009-8.39075-1.78055-8.94769,1.46033-13.88788,9.96188-46.829,2.43869,81.21808-3.403,7.75378,1.89376,8.5116-4.219,4.51819-1.66748,75.98993,19.25439.90063,15.9311-76.60315-1.23529-9.77545,2.1195-7.22791V594.85387l3.63025-7.96808,7.914-43.44751s2.38742-33.95831-15.03183-73.91895Z"
                                transform="translate(-198.47381 -154.31245)" fill="#2f2e41" />
                            <path
                                d="M529.68385,365.01326s-24.17157,4.78046-28.33655,25.39468-6.84455,67.26288-6.84455,67.26288l.91214,6.49622,23.38169,5.42178,14.92358-65.36273Z"
                                transform="translate(-198.47381 -154.31245)" fill="#3f3d56" />
                            <path
                                d="M584.84711,371.97145s2.45014-3.43347,16.17112-3.963c.56491-.02179-.13456-1.14252-.13456-1.14252l6.59879-32.25272,21.9906,12.17527-3.7121,33.813L589.6254,421.70213Z"
                                transform="translate(-198.47381 -154.31245)" fill="#3f3d56" />
                            <path
                                d="M571.13981,468.12233c-10.3526.00079-25.936-1.14172-49.39554-4.62451a7.165,7.165,0,0,1-6.01373-5.99893,5.42418,5.42418,0,0,1-.91135-6.16007l.02179-.04278-.53155-.6265a5.80077,5.80077,0,0,1-.38681-7.01147l-7.2652-51.97477a21.89569,21.89569,0,0,1,15.22772-24.02145l2.682-.83508,10.14248-13.26648.2.00232,32.5607.4335,10.56662,13.41824,17.08081,4.02756.04438.26,3.96609,22.914c2.06241,11.91773-2.66794,16.606-8.70578,27.0863l1.77213,29.43436.804,1.46082a3.95918,3.95918,0,0,1-.94793,4.96774,7.71178,7.71178,0,0,1,.10507,4.7724l-.41794,1.38065c.00079.0397-.11054.60083-1.01254,1.2857C589.09928,466.23891,584.4304,468.12233,571.13981,468.12233Z"
                                transform="translate(-198.47381 -154.31245)" fill="#3f3d56" />
                            <path
                                d="M556.80378,718.27562l17.27774-1.03125v7.40253l16.42642,11.34466a4.6239,4.6239,0,0,1-2.62747,8.429H567.31068l-3.54551-7.32221-1.38433,7.32221h-7.75565Z"
                                transform="translate(-198.47381 -154.31245)" fill="#2f2e41" />
                            <circle cx="549.75371" cy="320.56323" r="25.52654"
                                transform="matrix(0.16018, -0.98709, 0.98709, 0.16018, -53.20484, 657.55723)"
                                fill="#9e616a" />
                            <path
                                d="M564.67988,295.61836c-9.35593-6.43451-17.59488-7.41464-24.36267-5.58966a8.89677,8.89677,0,0,0-3.55887-3.16012c-5.27838-13.30008-21.34168-21.28745-35.127-17.40467-13.87448,3.9079-23.44757,19.27674-20.83691,33.45273,1.61789,8.787,7.14792,16.39591,9.37222,25.04932,4.30573,16.75143-6.19781,35.94018-22.62927,41.34,15.55756,3.12384,32.68268-6.37912,38.264-21.23346,2.71084-7.215,2.87433-15.09237,3.219-22.79211a75.56441,75.56441,0,0,1,1.9426-15.783,33.72225,33.72225,0,0,1,2.51172-6.72034A22.99686,22.99686,0,0,1,524.4806,292.0992a8.778,8.778,0,0,0,1.28183,7.90252c-3.6485,4.57053-5.63455,9.51328-5.63455,12.47333-7.57935,13.8526,3.25924,25.75144,17.11218,33.3306a28.38088,28.38088,0,0,0,18.13275,3.16122l.57956-2.474.78522,2.22855,2.62121,7.47122q4.5358,2.19425,8.993,4.81055c-1.12893-5.30145-2.04214-10.59311-2.67059-15.767-.87006-7.04193,2.16293-17.52557,4.3508-23.90094a37.632,37.632,0,0,0,2.06033-12.2128v-.18173l2.13034,6.8428,7.75577-3.3085C580.53559,304.1989,581.97852,294.80348,564.67988,295.61836Z"
                                transform="translate(-198.47381 -154.31245)" fill="#2f2e41" />
                            <path
                                d="M883.647,745.68755H316.353a1.19069,1.19069,0,0,1,0-2.38135H883.647a1.19069,1.19069,0,0,1,0,2.38135Z"
                                transform="translate(-198.47381 -154.31245)" fill="#ccc" />
                            <circle id="aeef577c-289f-4c95-850d-f6939249b5af"
                                data-name="e4c91425-bc08-43ed-9b2d-9a6452dd6ab0" cx="266.70383" cy="330.43084"
                                r="22.81224" fill="#e6e6e6" />
                            <path
                                d="M808.41264,471.63265H728.39982a9.33671,9.33671,0,0,1-9.326-9.3263V418.72756a9.33618,9.33618,0,0,1,9.326-9.3257h80.01282a9.33618,9.33618,0,0,1,9.326,9.32568v43.57879A9.33671,9.33671,0,0,1,808.41264,471.63265Z"
                                transform="translate(-198.47381 -154.31245)" fill="#f2f2f2" />
                            <g id="a3c861bb-19cc-462b-bc3a-1f29faec5e60" data-name="bc9af32e-f7cd-4c85-a4cc-5543d455b8de">
                                <circle id="a24c8b8a-c30a-477e-8412-dbddb638fe0a"
                                    data-name="b56288f5-6382-4006-aaf1-aded98dde780" cx="611.11771" cy="287.50408"
                                    r="12.11453" fill="{{ $themeSettings->colors->primary_color }}" />
                                <path id="ac585bde-7a48-4e1f-a3d4-d671a5b024fe-118"
                                    data-name="b9aaef6b-2cfc-46ac-8dc0-30fdc28925de"
                                    d="M814.62215,440.79921h-4.119v-4.11893a.96921.96921,0,0,0-.96923-.96923h0a.96924.96924,0,0,0-.96923.96921v4.119H804.4458a.96923.96923,0,0,0-.96923.96921v0h0a.96921.96921,0,0,0,.96923.96923h4.11894v4.11892a.96921.96921,0,0,0,.96923.96923h0a.96923.96923,0,0,0,.96923-.96921v-4.11894h4.119a.96924.96924,0,0,0,.96923-.96921v0h0a.96921.96921,0,0,0-.96923-.96923Z"
                                    transform="translate(-198.47381 -154.31245)" fill="#fff" />
                            </g>
                            <path
                                d="M841.01058,459.26566h-65.938a10.56776,10.56776,0,0,1-10.556-10.55565V409.35014a1.94477,1.94477,0,0,1,3.88953,0v10.54109l76.59074,6.96239a5.84107,5.84107,0,0,1,5.73742,5.83365,1.94624,1.94624,0,0,1-.03325.35831l-3.85977,20.58457A5.84079,5.84079,0,0,1,841.01058,459.26566Zm-72.60435-35.46909V448.71a6.674,6.674,0,0,0,6.66643,6.66612h65.938a1.94687,1.94687,0,0,0,1.94477-1.94476,1.94624,1.94624,0,0,1,.03325-.35831l3.85058-20.53587a1.9473,1.9473,0,0,0-1.93907-1.79472c-.05888,0-.11743-.00253-.176-.00824Z"
                                transform="translate(-198.47381 -154.31245)"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                            <circle cx="559.07752" cy="319.86304" r="3.24127"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                            <circle cx="639.94379" cy="319.86304" r="3.24127"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                            <path
                                d="M841.65884,470.93421H754.95832a1.94476,1.94476,0,0,1,0-3.88952h86.70052a1.94476,1.94476,0,0,1,0,3.88952Z"
                                transform="translate(-198.47381 -154.31245)"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                            <path
                                d="M771.6475,410.64665H754.79289a1.94477,1.94477,0,0,1,0-3.88953H771.6475a1.94477,1.94477,0,0,1,0,3.88953Z"
                                transform="translate(-198.47381 -154.31245)"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                            <path
                                d="M785.16871,469.94411a1.93725,1.93725,0,0,1-1.26643-.46972l-12.78276-10.98486a1.94474,1.94474,0,1,1,2.53475-2.95009L786.437,466.52431a1.94476,1.94476,0,0,1-1.26832,3.41978Z"
                                transform="translate(-198.47381 -154.31245)"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                            <path
                                d="M787.86214,458.07106a1.94464,1.94464,0,0,1-1.94476-1.94453V424.9082a1.94476,1.94476,0,0,1,3.88952,0v31.2181a1.94463,1.94463,0,0,1-1.94451,1.94476Z"
                                transform="translate(-198.47381 -154.31245)"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                            <path
                                d="M828.94353,458.07106a1.94464,1.94464,0,0,1-1.94477-1.94455V427.50124a1.94477,1.94477,0,0,1,3.88953,0v28.62508a1.94464,1.94464,0,0,1-1.94456,1.94474Z"
                                transform="translate(-198.47381 -154.31245)"
                                fill="{{ $themeSettings->colors->primary_color }}" />
                        </svg>
                    </div>
                    <div class="mb-4">
                        <h4>{{ translate('You do not have any purchases') }}</h4>
                        <p class="mb-0">
                            {{ translate('When you purchase item, you will be able to see them here.') }}
                        </p>
                    </div>
                    @include('themes.basic.partials.browse-items-button')
                </div>
            </div>
        @endif
    </div>
    {{ $purchases->links() }}
    <div class="modal fade" id="purchaseCodeModal" tabindex="-1" aria-labelledby="purchaseCodeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content p-4">
                <div class="modal-header border-0 p-0 mb-4">
                    <h1 class="modal-title fs-5" id="purchaseCodeModalLabel">
                        {{ translate('Your Purchase Code') }}</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-0">
                    <div class="input-group mb-3">
                        <input id="purchaseCode" type="text" class="form-control form-control-md " value=""
                            readonly>
                        <button class="btn btn-primary btn-copy" data-clipboard-target="#purchaseCode"><i
                                class="far fa-clone"></i></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="supportPurchaseModal" tabindex="-1" aria-labelledby="supportPurchaseModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content p-4">
                <div class="modal-header border-0 p-0 mb-3">
                    <h1 class="modal-title fs-5" id="supportPurchaseModalLabel">{{ translate('Buy Support') }}</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-0">
                    <form action="#" method="POST">
                        @csrf
                        <div class="mb-3">
                            <select name="support" class="form-select form-select-md">
                                @foreach ($supportPeriods as $supportPeriod)
                                    <option value="{{ $supportPeriod->id }}">{{ $supportPeriod->title }}</option>
                                @endforeach
                            </select>
                        </div>
                        <button class="btn btn-primary btn-md w-100">{{ translate('Continue') }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="supportExtendModal" tabindex="-1" aria-labelledby="supportExtendModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content p-4">
                <div class="modal-header border-0 p-0 mb-3">
                    <h1 class="modal-title fs-5" id="supportExtendModalLabel">{{ translate('Extend Support') }}</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-0">
                    <form action="#" method="POST">
                        @csrf
                        <div class="mb-3">
                            <select name="support" class="form-select form-select-md">
                                @foreach ($supportPeriods as $supportPeriod)
                                    <option value="{{ $supportPeriod->id }}">{{ $supportPeriod->title }}</option>
                                @endforeach
                            </select>
                        </div>
                        <button class="btn btn-danger btn-md w-100">{{ translate('Continue') }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    @push('scripts_libs')
        <script src="{{ asset('vendor/libs/clipboard/clipboard.min.js') }}"></script>
    @endpush
    @push('scripts')
        <script>
            "use strict";
            let itemPurchaseCode = $('.item-purchase-code');
            itemPurchaseCode.on('click', function(e) {
                e.preventDefault();
                let purchaseCode = $(this).data('purchase-code'),
                    purchaseCodeModal = $('#purchaseCodeModal');
                purchaseCodeModal.find('input[id=purchaseCode]').val(purchaseCode);
                purchaseCodeModal.modal('show');
            });

            let supportPurchase = $('.support-purchase');
            supportPurchase.on('click', function() {
                let action = $(this).data('action'),
                    supportPurchaseModal = $('#supportPurchaseModal'),
                    modalForm = supportPurchaseModal.find('form');
                modalForm.attr('action', action);
                supportPurchaseModal.modal('show');
            });

            let supportExtend = $('.support-extend');
            supportExtend.on('click', function() {
                let action = $(this).data('action'),
                    supportExtendModal = $('#supportExtendModal'),
                    modalForm = supportExtendModal.find('form');
                modalForm.attr('action', action);
                supportExtendModal.modal('show');
            });
        </script>
    @endpush
@endsection
